# test_get_video_start_time.py
import tkinter as tk
from tkinter import filedialog
from datetime import datetime

def get_video_start_time(srt_path):
    with open(srt_path, 'r', encoding='utf-8') as file:
        for line in file:
            line = line.strip()
            if not line or '-->' in line:
                continue  # skip blank lines and timestamp lines
            try:
                # Try parsing as a time string
                return datetime.strptime(line, "%H:%M:%S")
            except ValueError:
                try:
                    return datetime.strptime(line, "%H:%M:%S.%f")
                except ValueError:
                    continue  # Not a valid time
    raise ValueError("No valid time found in subtitle file.")

def main():
    # GUI to select subtitle file
    root = tk.Tk()
    root.withdraw()  # Hide the root window

    srt_path = filedialog.askopenfilename(
        title="Select Subtitle File",
        filetypes=[("SubRip Subtitle files", "*.srt"), ("All files", "*.*")]
    )

    if not srt_path:
        print("No file selected.")
        return

    try:
        video_start_time = get_video_start_time(srt_path)
        print(f"Video starts at: {video_start_time.time()}")
    except Exception as e:
        print(f"Error: {e}")

if __name__ == "__main__":
    main()
